/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.membranechannels.model.Particle;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class ParticleNode
extends PNode {
    private static final Stroke PARTICLE_EDGE_STROKE = new BasicStroke(1.0f);
    private Particle particle;
    private ModelViewTransform2D modelViewTransform;
    private PNode representation;

    public ParticleNode(Particle particle, ModelViewTransform2D modelViewTransform2D) {
        this.particle = particle;
        this.modelViewTransform = modelViewTransform2D;
        particle.addListener(new Particle.Adapter(){

            public void positionChanged() {
                ParticleNode.this.updateOffset();
            }
        });
        this.representation = this.createRepresentation();
        this.addChild(this.representation);
        this.updateOffset();
    }

    private void updateOffset() {
        this.setOffset(this.modelViewTransform.modelToView(this.particle.getPosition()));
    }

    public Image toImage() {
        PPath pPath = new PPath();
        pPath.addChild(this);
        pPath.setPaint(new Color(0, 0, 0, 0));
        pPath.setStroke(null);
        double d = 2.0;
        pPath.setPathTo(new Rectangle2D.Double(this.getFullBoundsReference().x - d, this.getFullBoundsReference().y - d, this.getFullBoundsReference().width + d * 2.0 + 0.5, this.getFullBoundsReference().height + d * 2.0 + 0.5));
        return pPath.toImage();
    }

    private PNode createRepresentation() {
        PNode pNode;
        switch (this.particle.getType()) {
            case SODIUM_ION: {
                SphericalNode sphericalNode = new SphericalNode(this.modelViewTransform.modelToViewDifferentialXDouble(this.particle.getDiameter()), this.particle.getRepresentationColor(), false);
                sphericalNode.setStroke(PARTICLE_EDGE_STROKE);
                sphericalNode.setStrokePaint(Color.BLACK);
                pNode = sphericalNode;
                break;
            }
            case POTASSIUM_ION: {
                double d = this.modelViewTransform.modelToViewDifferentialXDouble(this.particle.getDiameter()) * 0.85;
                PPath pPath = new PPath(new Rectangle2D.Double(-d / 2.0, -d / 2.0, d, d));
                pPath.setPaint(this.particle.getRepresentationColor());
                pPath.setStroke(PARTICLE_EDGE_STROKE);
                pPath.setStrokePaint(Color.BLACK);
                pPath.rotate(0.7853981633974483);
                pNode = pPath;
                break;
            }
            case PROTEIN_ION: {
                double d = this.modelViewTransform.modelToViewDifferentialXDouble(this.particle.getDiameter());
                double d2 = d * 1.5;
                double d3 = d * 0.8;
                PPath pPath = new PPath(new Ellipse2D.Double(-d2 / 2.0, -d3 / 2.0, d2, d3));
                pPath.setPaint(this.particle.getRepresentationColor());
                pPath.setStroke(PARTICLE_EDGE_STROKE);
                pPath.setStrokePaint(Color.BLACK);
                pNode = pPath;
                break;
            }
            default: {
                System.err.println(this.getClass().getName() + " - Warning: No specific shape for this particle type, defaulting to sphere.");
                pNode = new SphericalNode(this.modelViewTransform.modelToViewDifferentialXDouble(this.particle.getDiameter()), this.particle.getRepresentationColor(), true);
            }
        }
        return pNode;
    }
}

