/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.membranechannels.MembraneChannelsConstants;
import edu.colorado.phet.membranechannels.MembraneChannelsStrings;
import edu.colorado.phet.membranechannels.model.MembraneChannel;
import edu.colorado.phet.membranechannels.model.MembraneChannelsModel;
import edu.colorado.phet.membranechannels.model.Particle;
import edu.colorado.phet.membranechannels.model.ParticleType;
import edu.colorado.phet.membranechannels.module.MembraneChannelsDefaults;
import edu.colorado.phet.membranechannels.view.ConcentrationGraph;
import edu.colorado.phet.membranechannels.view.GatedChannelToolBox;
import edu.colorado.phet.membranechannels.view.LeakChannelToolBox;
import edu.colorado.phet.membranechannels.view.MembraneChannelNode;
import edu.colorado.phet.membranechannels.view.ParticleInjectorNode;
import edu.colorado.phet.membranechannels.view.ParticleNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MembraneChannelsCanvas
extends PhetPCanvas {
    private MembraneChannelsModel model;
    private ModelViewTransform2D mvt;
    private PNode myWorldNode;
    private PNode particleLayer;
    private PNode chamberLayer;
    private PNode membraneLayer;
    private PNode channelLayer;
    private PNode channelEdgeLayer;
    private PNode chartLayer;
    private PNode toolBoxLayer;
    private PNode injectorLayer;
    private LeakChannelToolBox leakChannelToolBoxNode;
    private GatedChannelToolBox gatedChannelToolBoxNode;

    public MembraneChannelsCanvas(MembraneChannelsModel membraneChannelsModel) {
        this.model = membraneChannelsModel;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteringBoxStrategy(this, MembraneChannelsDefaults.INTERMEDIATE_RENDERING_SIZE));
        this.mvt = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point((int)Math.round(MembraneChannelsDefaults.INTERMEDIATE_RENDERING_SIZE.width * 0.55), (int)Math.round(MembraneChannelsDefaults.INTERMEDIATE_RENDERING_SIZE.height * 0.35)), 8.0, true);
        this.setBackground(MembraneChannelsConstants.CANVAS_BACKGROUND);
        membraneChannelsModel.addListener(new MembraneChannelsModel.Adapter(){

            public void particleAdded(Particle particle) {
                MembraneChannelsCanvas.this.addParticleNode(particle);
            }

            public void channelAdded(MembraneChannel membraneChannel) {
                MembraneChannelsCanvas.this.addChannelNode(membraneChannel);
            }
        });
        this.myWorldNode = new PNode();
        this.addWorldChild(this.myWorldNode);
        this.chamberLayer = new PNode();
        this.membraneLayer = new PNode();
        this.particleLayer = new PNode();
        this.toolBoxLayer = new PNode();
        this.injectorLayer = new PNode();
        this.channelLayer = new PNode();
        this.channelEdgeLayer = new PNode();
        this.myWorldNode.addChild(this.chamberLayer);
        this.myWorldNode.addChild(this.membraneLayer);
        this.myWorldNode.addChild(this.toolBoxLayer);
        this.myWorldNode.addChild(this.channelLayer);
        this.myWorldNode.addChild(this.particleLayer);
        this.myWorldNode.addChild(this.channelEdgeLayer);
        this.myWorldNode.addChild(this.injectorLayer);
        this.chartLayer = new PNode();
        this.addWorldChild(this.chartLayer);
        Rectangle2D rectangle2D = this.mvt.createTransformedShape(MembraneChannelsModel.getOverallParticleChamberRect()).getBounds2D();
        PhetPPath phetPPath = new PhetPPath((Shape)rectangle2D, new Color(199, 234, 252));
        this.chamberLayer.addChild(phetPPath);
        Rectangle2D rectangle2D2 = MembraneChannelsModel.getMembraneRect();
        Rectangle2D rectangle2D3 = this.mvt.createTransformedShape(rectangle2D2).getBounds2D();
        PhetPPath phetPPath2 = new PhetPPath(rectangle2D3, Color.YELLOW, new BasicStroke(1.0f), Color.BLACK);
        PText pText = new PText(MembraneChannelsStrings.MEMBRANE);
        pText.setFont(new PhetFont());
        pText.setScale(rectangle2D3.getHeight() * 0.7 / pText.getFullBoundsReference().height);
        pText.setOffset(rectangle2D3.getMinX() + 10.0, rectangle2D3.getCenterY() - pText.getFullBoundsReference().height / 2.0);
        phetPPath2.addChild(pText);
        this.membraneLayer.addChild(phetPPath2);
        ParticleInjectorNode particleInjectorNode = new ParticleInjectorNode(ParticleType.SODIUM_ION, membraneChannelsModel, this.mvt, 0.0);
        particleInjectorNode.setOffset(rectangle2D.getMinX() - particleInjectorNode.getFullBoundsReference().getMaxX() + 20.0, rectangle2D.getMinY() + rectangle2D.getHeight() * 0.2);
        this.injectorLayer.addChild(particleInjectorNode);
        ParticleInjectorNode particleInjectorNode2 = new ParticleInjectorNode(ParticleType.POTASSIUM_ION, membraneChannelsModel, this.mvt, 0.0);
        particleInjectorNode2.setOffset(rectangle2D.getMinX() - particleInjectorNode2.getFullBoundsReference().getMaxX() + 20.0, rectangle2D.getMaxY() - rectangle2D.getHeight() * 0.2);
        this.injectorLayer.addChild(particleInjectorNode2);
        double d = 30.0;
        this.leakChannelToolBoxNode = new LeakChannelToolBox(new PDimension(rectangle2D.getWidth() * 0.6, rectangle2D.getHeight() * 0.4), membraneChannelsModel, this.mvt, this);
        this.leakChannelToolBoxNode.setOffset(rectangle2D.getCenterX() - this.leakChannelToolBoxNode.getFullBoundsReference().width - d / 2.0, rectangle2D.getMaxY() + 40.0);
        this.toolBoxLayer.addChild(this.leakChannelToolBoxNode);
        this.gatedChannelToolBoxNode = new GatedChannelToolBox(new PDimension(rectangle2D.getWidth() * 0.6, rectangle2D.getHeight() * 0.4), membraneChannelsModel, this.mvt, this);
        this.gatedChannelToolBoxNode.setOffset(rectangle2D.getCenterX() + d / 2.0, rectangle2D.getMaxY() + 40.0);
        this.toolBoxLayer.addChild(this.gatedChannelToolBoxNode);
        ConcentrationGraph concentrationGraph = new ConcentrationGraph(membraneChannelsModel, true);
        concentrationGraph.setOffset(rectangle2D.getMaxX() + 20.0, rectangle2D.getMinY() + 10.0);
        this.chartLayer.addChild(concentrationGraph);
        ConcentrationGraph concentrationGraph2 = new ConcentrationGraph(membraneChannelsModel, false);
        concentrationGraph2.setOffset(rectangle2D.getMaxX() + 20.0, rectangle2D3.getMaxY() + 10.0);
        this.chartLayer.addChild(concentrationGraph2);
        this.updateLayout();
    }

    private void addParticleNode(Particle particle) {
        final ParticleNode particleNode = new ParticleNode(particle, this.mvt);
        this.particleLayer.addChild(particleNode);
        particle.addListener(new Particle.Adapter(){

            public void removedFromModel() {
                MembraneChannelsCanvas.this.particleLayer.removeChild(particleNode);
            }
        });
    }

    private void addChannelNode(MembraneChannel membraneChannel) {
        final MembraneChannelNode membraneChannelNode = new MembraneChannelNode(membraneChannel, this.mvt);
        membraneChannelNode.addToCanvas(this.channelLayer, this.channelEdgeLayer);
        membraneChannel.addListener(new MembraneChannel.Adapter(){

            public void removed() {
                membraneChannelNode.cleanup();
                if (!MembraneChannelsModel.getOverallParticleChamberRect().contains(membraneChannelNode.getMembraneChannel().getCenterLocation()) || MembraneChannelsCanvas.this.model.isMembraneFull()) {
                    membraneChannelNode.addListener(new MembraneChannelNode.Listener(){

                        public void removalAnimationComplete() {
                            membraneChannelNode.removeFromCanvas(MembraneChannelsCanvas.this.channelLayer, MembraneChannelsCanvas.this.channelEdgeLayer);
                        }
                    });
                    membraneChannelNode.startRemovalAnimation();
                } else {
                    membraneChannelNode.removeFromCanvas(MembraneChannelsCanvas.this.channelLayer, MembraneChannelsCanvas.this.channelEdgeLayer);
                }
            }
        });
    }
}

