/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.membranechannels.model.MembraneChannel;
import edu.colorado.phet.membranechannels.view.RestoreDefaultOnReleaseCursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.Timer;

public class MembraneChannelNode
extends PNode {
    private MembraneChannel membraneChannel;
    private ModelViewTransform2D mvt;
    private PNode channelLayer;
    private PNode edgeLayer;
    private PPath channel;
    private PPath leftEdgeNode;
    private PPath rightEdgeNode;
    private RestoreDefaultOnReleaseCursorHandler cursorHandler = new RestoreDefaultOnReleaseCursorHandler(12);
    private PDragEventHandler dragEventHandler = new PDragEventHandler(){

        public void startDrag(PInputEvent pInputEvent) {
            super.startDrag(pInputEvent);
            MembraneChannelNode.this.membraneChannel.setUserControlled(true);
        }

        public void drag(PInputEvent pInputEvent) {
            PNode pNode = pInputEvent.getPickedNode();
            PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
            pNode.localToParent(pDimension);
            double d = MembraneChannelNode.this.membraneChannel.getCenterLocation().getX() + MembraneChannelNode.this.mvt.viewToModelDifferentialX(pDimension.getWidth());
            double d2 = MembraneChannelNode.this.membraneChannel.getCenterLocation().getY() + MembraneChannelNode.this.mvt.viewToModelDifferentialY(pDimension.getHeight());
            MembraneChannelNode.this.membraneChannel.setCenterLocation(d, d2);
        }

        public void endDrag(PInputEvent pInputEvent) {
            super.endDrag(pInputEvent);
            MembraneChannelNode.this.membraneChannel.setUserControlled(false);
        }
    };
    private ArrayList<Listener> listeners = new ArrayList();
    private RemovalAnimationTimer removalAnimationTimer;
    private Point2D initialOffset = new Point2D.Double();

    public MembraneChannelNode(MembraneChannel membraneChannel, ModelViewTransform2D modelViewTransform2D) {
        this.membraneChannel = membraneChannel;
        this.mvt = modelViewTransform2D;
        membraneChannel.addListener(new MembraneChannel.Adapter(){

            public void opennessChanged() {
                MembraneChannelNode.this.updateRepresentation();
            }

            public void positionChanged() {
                MembraneChannelNode.this.updateLocation();
            }
        });
        this.channel = new PhetPPath(membraneChannel.getChannelColor());
        double d = (membraneChannel.getOverallSize().getWidth() - membraneChannel.getChannelSize().getWidth()) / 2.0;
        double d2 = membraneChannel.getOverallSize().getHeight();
        PDimension pDimension = new PDimension(Math.abs(modelViewTransform2D.modelToViewDifferentialXDouble(d)), Math.abs(modelViewTransform2D.modelToViewDifferentialYDouble(d2)));
        if (membraneChannel.isGated()) {
            this.leftEdgeNode = this.createRoundedEdgeNode(pDimension, membraneChannel.getEdgeColor());
            this.rightEdgeNode = this.createRoundedEdgeNode(pDimension, membraneChannel.getEdgeColor());
        } else {
            this.leftEdgeNode = this.createSquarishEdgeNode(pDimension, membraneChannel.getEdgeColor());
            this.rightEdgeNode = this.createSquarishEdgeNode(pDimension, membraneChannel.getEdgeColor());
        }
        this.channelLayer = new PNode();
        this.addChild(this.channelLayer);
        this.channelLayer.addChild(this.channel);
        this.edgeLayer = new PNode();
        this.addChild(this.edgeLayer);
        this.edgeLayer.addChild(this.leftEdgeNode);
        this.edgeLayer.addChild(this.rightEdgeNode);
        this.channelLayer.addInputEventListener(this.cursorHandler);
        this.channelLayer.addInputEventListener(this.dragEventHandler);
        this.edgeLayer.addInputEventListener(this.cursorHandler);
        this.edgeLayer.addInputEventListener(this.dragEventHandler);
        this.updateRepresentation();
        this.updateLocation();
        this.initialOffset.setLocation(this.channelLayer.getOffset());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyRemovalAnimationComplete() {
        ArrayList<Listener> arrayList = new ArrayList<Listener>(this.listeners);
        for (Listener listener : arrayList) {
            listener.removalAnimationComplete();
        }
    }

    public void addToCanvas(PNode pNode, PNode pNode2) {
        pNode.addChild(this.channelLayer);
        pNode2.addChild(this.edgeLayer);
    }

    public void removeFromCanvas(PNode pNode, PNode pNode2) {
        pNode.removeChild(this.channelLayer);
        pNode2.removeChild(this.edgeLayer);
    }

    public MembraneChannel getMembraneChannel() {
        return this.membraneChannel;
    }

    public void startRemovalAnimation() {
        this.removalAnimationTimer = new RemovalAnimationTimer(this);
        this.removalAnimationTimer.start();
    }

    private PPath createRoundedEdgeNode(Dimension2D dimension2D, Color color) {
        GeneralPath generalPath = new GeneralPath();
        float f = (float)dimension2D.getWidth();
        float f2 = (float)dimension2D.getHeight();
        generalPath.moveTo(-f / 2.0f, f2 / 4.0f);
        generalPath.curveTo(-f / 2.0f, f2 * 0.6f, f / 2.0f, f2 * 0.6f, f / 2.0f, f2 / 4.0f);
        generalPath.lineTo(f / 2.0f, -f2 / 4.0f);
        generalPath.curveTo(f / 2.0f, -f2 * 0.6f, -f / 2.0f, -f2 * 0.6f, -f / 2.0f, -f2 / 4.0f);
        generalPath.closePath();
        PPath pPath = new PPath(generalPath);
        pPath.setPaint(color);
        pPath.setStrokePaint(ColorUtils.darkerColor(color, 0.3));
        return pPath;
    }

    private PPath createSquarishEdgeNode(Dimension2D dimension2D, Color color) {
        double d = dimension2D.getWidth() / 2.0;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(-dimension2D.getWidth() / 2.0, -dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight(), d, d);
        PPath pPath = new PPath(double_);
        pPath.setPaint(color);
        pPath.setStrokePaint(ColorUtils.darkerColor(color, 0.3));
        return pPath;
    }

    private void updateLocation() {
        this.channelLayer.setOffset(this.mvt.modelToViewDouble(this.membraneChannel.getCenterLocation()));
        this.edgeLayer.setOffset(this.mvt.modelToViewDouble(this.membraneChannel.getCenterLocation()));
    }

    private void updateRepresentation() {
        double d = this.membraneChannel.getChannelSize().getWidth() * this.membraneChannel.getOpenness();
        PDimension pDimension = new PDimension(d, this.membraneChannel.getChannelSize().getHeight());
        PDimension pDimension2 = new PDimension(Math.abs(this.mvt.modelToViewDifferentialXDouble(((Dimension2D)pDimension).getWidth())), Math.abs(this.mvt.modelToViewDifferentialYDouble(((Dimension2D)pDimension).getHeight())));
        float f = 1.1f;
        float f2 = (float)((Dimension2D)pDimension2).getWidth() * f;
        float f3 = (float)((Dimension2D)pDimension2).getHeight() * f;
        float f4 = (float)this.leftEdgeNode.getFullBoundsReference().width;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.quadTo((f2 + f4) / 2.0f, f3 / 8.0f, f2 + f4, 0.0f);
        generalPath.lineTo(f2 + f4, f3);
        generalPath.quadTo((f2 + f4) / 2.0f, f3 * 7.0f / 8.0f, 0.0f, f3);
        generalPath.closePath();
        this.channel.setPathTo(generalPath);
        this.channel.setOffset(-this.channel.getFullBoundsReference().width / 2.0, -this.channel.getFullBoundsReference().height / 2.0);
        this.leftEdgeNode.setOffset(-((Dimension2D)pDimension2).getWidth() / 2.0 - this.leftEdgeNode.getFullBoundsReference().width / 2.0, 0.0);
        this.rightEdgeNode.setOffset(((Dimension2D)pDimension2).getWidth() / 2.0 + this.rightEdgeNode.getFullBoundsReference().width / 2.0, 0.0);
    }

    public void cleanup() {
        this.edgeLayer.removeInputEventListener(this.cursorHandler);
        this.edgeLayer.removeInputEventListener(this.dragEventHandler);
        this.channelLayer.removeInputEventListener(this.cursorHandler);
        this.channelLayer.removeInputEventListener(this.dragEventHandler);
    }

    public static interface Listener {
        public void removalAnimationComplete();
    }

    private static class RemovalAnimationTimer
    extends Timer {
        private AnimationStage animationStage = AnimationStage.MOVING_BACK_TO_TOOL_BOX;
        private MembraneChannelNode membraneChannelNode;

        public RemovalAnimationTimer(MembraneChannelNode membraneChannelNode) {
            super(30, null);
            this.membraneChannelNode = membraneChannelNode;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RemovalAnimationTimer.this.animationStage == AnimationStage.MOVING_BACK_TO_TOOL_BOX) {
                        double d = RemovalAnimationTimer.this.membraneChannelNode.channelLayer.getOffset().distance(RemovalAnimationTimer.this.membraneChannelNode.initialOffset);
                        if (d < 20.0) {
                            RemovalAnimationTimer.this.membraneChannelNode.channelLayer.setOffset(RemovalAnimationTimer.this.membraneChannelNode.initialOffset);
                            RemovalAnimationTimer.this.membraneChannelNode.edgeLayer.setOffset(RemovalAnimationTimer.this.membraneChannelNode.initialOffset);
                            RemovalAnimationTimer.this.animationStage = AnimationStage.SHRINKING;
                        } else {
                            double d2 = Math.atan2(RemovalAnimationTimer.this.membraneChannelNode.initialOffset.getY() - RemovalAnimationTimer.this.membraneChannelNode.channelLayer.getOffset().getY(), RemovalAnimationTimer.this.membraneChannelNode.initialOffset.getX() - RemovalAnimationTimer.this.membraneChannelNode.channelLayer.getOffset().getX());
                            double d3 = RemovalAnimationTimer.this.membraneChannelNode.channelLayer.getOffset().getX() + 20.0 * Math.cos(d2);
                            double d4 = RemovalAnimationTimer.this.membraneChannelNode.channelLayer.getOffset().getY() + 20.0 * Math.sin(d2);
                            RemovalAnimationTimer.this.membraneChannelNode.channelLayer.setOffset(d3, d4);
                            RemovalAnimationTimer.this.membraneChannelNode.edgeLayer.setOffset(d3, d4);
                        }
                    }
                    if (RemovalAnimationTimer.this.animationStage == AnimationStage.SHRINKING) {
                        RemovalAnimationTimer.this.stop();
                        RemovalAnimationTimer.this.membraneChannelNode.notifyRemovalAnimationComplete();
                    }
                }
            });
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class AnimationStage
        extends Enum<AnimationStage> {
            public static final /* enum */ AnimationStage MOVING_BACK_TO_TOOL_BOX = new AnimationStage();
            public static final /* enum */ AnimationStage SHRINKING = new AnimationStage();
            private static final /* synthetic */ AnimationStage[] $VALUES;

            public static AnimationStage[] values() {
                return (AnimationStage[])$VALUES.clone();
            }

            static {
                $VALUES = new AnimationStage[]{MOVING_BACK_TO_TOOL_BOX, SHRINKING};
            }
        }
    }
}

