/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.module;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.clock.TimeSpeedSlider;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.membranechannels.MembraneChannelsStrings;
import edu.colorado.phet.membranechannels.controlpanel.MembraneChannelsControlPanel;
import edu.colorado.phet.membranechannels.model.MembraneChannelsClock;
import edu.colorado.phet.membranechannels.model.MembraneChannelsModel;
import edu.colorado.phet.membranechannels.view.MembraneChannelsCanvas;
import java.awt.Frame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MembraneChannelsModule
extends PiccoloModule {
    private final MembraneChannelsModel model;
    private final MembraneChannelsCanvas canvas;
    private final MembraneChannelsControlPanel controlPanel;
    private final PiccoloClockControlPanel clockControlPanel;

    public MembraneChannelsModule(Frame frame) {
        super(MembraneChannelsStrings.TITLE_MEMBRANE_CHANNELS_MODULE, new MembraneChannelsClock(25, 0.04));
        MembraneChannelsClock membraneChannelsClock = (MembraneChannelsClock)this.getClock();
        this.model = new MembraneChannelsModel(membraneChannelsClock);
        this.canvas = new MembraneChannelsCanvas(this.model);
        this.setSimulationPanel(this.canvas);
        this.controlPanel = new MembraneChannelsControlPanel(this, this.model);
        this.setControlPanel(this.controlPanel);
        this.clockControlPanel = new PiccoloClockControlPanel(this.getClock());
        final TimeSpeedSlider timeSpeedSlider = new TimeSpeedSlider(0.013333333333333334, 0.064, "0.00", (ConstantDtClock)this.getClock());
        timeSpeedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((ConstantDtClock)MembraneChannelsModule.this.getClock()).setDt(timeSpeedSlider.getValue());
            }
        });
        this.clockControlPanel.addBetweenTimeDisplayAndButtons(timeSpeedSlider);
        this.setClockControlPanel(this.clockControlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
    }

    public void reset() {
        this.model.reset();
    }
}

