/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.membranechannels.model.IMovable;
import java.util.ArrayList;

public abstract class MotionStrategy {
    protected ArrayList<Listener> listeners = new ArrayList();

    public abstract void move(IMovable var1, double var2);

    public abstract Vector2D getInstantaneousVelocity();

    public void addListener(Listener listener) {
        if (this.listeners.contains(listener)) {
            System.err.println(this.getClass().getName() + "- Warning: Attempting to re-add a listener that is already listening.");
            assert (false);
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void notifyStrategyComplete(IMovable iMovable) {
        ArrayList<Listener> arrayList = new ArrayList<Listener>(this.listeners);
        for (Listener listener : arrayList) {
            listener.strategyComplete(iMovable);
        }
    }

    public static class Adapter
    implements Listener {
        public void strategyComplete(IMovable iMovable) {
        }
    }

    public static interface Listener {
        public void strategyComplete(IMovable var1);
    }
}

