/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.membranechannels.model.ChannelAlwaysClosedStrategy;
import edu.colorado.phet.membranechannels.model.ChannelAlwaysOpenStrategy;
import java.util.ArrayList;

public abstract class MembraneChannelOpennessStrategy {
    public static final MembraneChannelOpennessStrategy CHANNEL_ALWAYS_OPEN = new ChannelAlwaysOpenStrategy();
    public static final MembraneChannelOpennessStrategy CHANNEL_ALWAYS_CLOSED = new ChannelAlwaysClosedStrategy();
    double openness = 0.0;
    private ArrayList<Listener> listeners = new ArrayList();

    protected MembraneChannelOpennessStrategy(ConstantDtClock constantDtClock) {
        constantDtClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                MembraneChannelOpennessStrategy.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
    }

    protected MembraneChannelOpennessStrategy() {
    }

    public double getOpenness() {
        return this.openness;
    }

    protected void setOpenness(double d) {
        assert (this.openness >= 0.0 && this.openness <= 1.0);
        if (this.openness != d) {
            this.openness = d;
            this.notifyOpennessChanged();
        }
    }

    protected void stepInTime(double d) {
    }

    protected abstract boolean isDynamic();

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    protected void notifyOpennessChanged() {
        for (Listener listener : this.listeners) {
            listener.opennessChanged();
        }
    }

    public static interface Listener {
        public void opennessChanged();
    }
}

