/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.membranechannels.model.IMovable;
import edu.colorado.phet.membranechannels.model.MotionStrategy;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BoundedLinearMotionStrategy
extends MotionStrategy {
    private Vector2D velocity;
    private Rectangle2D motionBounds = new Rectangle2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public BoundedLinearMotionStrategy(Vector2D vector2D, Rectangle2D rectangle2D) {
        this.velocity = vector2D;
        this.motionBounds.setFrame(rectangle2D);
    }

    public void move(IMovable iMovable, double d) {
        Point2D point2D = iMovable.getPositionReference();
        double d2 = iMovable.getRadius();
        if (point2D.getX() + d2 > this.motionBounds.getMaxX() && this.velocity.getX() > 0.0 || point2D.getX() - d2 < this.motionBounds.getMinX() && this.velocity.getX() < 0.0) {
            this.velocity.setComponents(-this.velocity.getX(), this.velocity.getY());
        }
        if (point2D.getY() + d2 > this.motionBounds.getMaxY() && this.velocity.getY() > 0.0 || point2D.getY() - d2 < this.motionBounds.getMinY() && this.velocity.getY() < 0.0) {
            this.velocity.setComponents(this.velocity.getX(), -this.velocity.getY());
        }
        iMovable.setPosition(point2D.getX() + this.velocity.getX() * d, point2D.getY() + this.velocity.getY() * d);
    }

    public Vector2D getInstantaneousVelocity() {
        return new Vector2D(this.velocity.getX(), this.velocity.getY());
    }
}

