/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.controlpanel;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.membranechannels.MembraneChannelsConstants;
import edu.colorado.phet.membranechannels.MembraneChannelsResources;
import edu.colorado.phet.membranechannels.MembraneChannelsStrings;
import edu.colorado.phet.membranechannels.model.MembraneChannel;
import edu.colorado.phet.membranechannels.model.MembraneChannelTypes;
import edu.colorado.phet.membranechannels.model.MembraneChannelsModel;
import edu.colorado.phet.membranechannels.model.Particle;
import edu.colorado.phet.membranechannels.model.PotassiumIon;
import edu.colorado.phet.membranechannels.model.SodiumIon;
import edu.colorado.phet.membranechannels.view.ParticleNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class MembraneChannelsControlPanel
extends ControlPanel {
    private final JCheckBox showConcentrationsCheckBox;
    private final MembraneChannelsModel model;
    private final JButton sodiumGatedChannelControlButton;
    private final JButton potassiumGatedChannelControlButton;
    private final JButton clearParticlesButton;

    public MembraneChannelsControlPanel(PiccoloModule piccoloModule, final MembraneChannelsModel membraneChannelsModel) {
        this.model = membraneChannelsModel;
        membraneChannelsModel.addListener(new MembraneChannelsModel.Adapter(){

            public void concentrationGraphVisibilityChanged() {
                MembraneChannelsControlPanel.this.updateConcentrationsCheckBoxState();
            }

            public void sodiumGateOpennessChanged() {
                MembraneChannelsControlPanel.this.updateMembraneChannelControlButtons();
            }

            public void potassiumGateOpennessChanged() {
                MembraneChannelsControlPanel.this.updateMembraneChannelControlButtons();
            }

            public void channelAdded(MembraneChannel membraneChannel) {
                MembraneChannelsControlPanel.this.updateMembraneChannelControlButtons();
                membraneChannel.addListener(new MembraneChannelRemovalListener(membraneChannel, MembraneChannelsControlPanel.this));
            }

            public void particleAdded(Particle particle) {
                MembraneChannelsControlPanel.this.updateClearParticlesButton();
                particle.addListener(new ParticleRemovalListener(particle, MembraneChannelsControlPanel.this));
            }
        });
        int n = MembraneChannelsResources.getInt("int.minControlPanelWidth", 215);
        this.setMinimumWidth(n);
        this.addControlFullWidth(this.createVerticalSpacingPanel(20));
        Dimension dimension = new Dimension((int)Math.round((double)n * 0.9), 40);
        this.sodiumGatedChannelControlButton = new JButton();
        this.sodiumGatedChannelControlButton.setPreferredSize(dimension);
        this.sodiumGatedChannelControlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                membraneChannelsModel.setGatedSodiumChannelsOpen(membraneChannelsModel.getGatedSodiumChannelOpenness() < 0.5);
            }
        });
        this.potassiumGatedChannelControlButton = new JButton();
        this.potassiumGatedChannelControlButton.setPreferredSize(dimension);
        this.potassiumGatedChannelControlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                membraneChannelsModel.setGatedPotassiumChannelsOpen(membraneChannelsModel.getGatedPotassiumChannelOpenness() < 0.5);
            }
        });
        this.updateMembraneChannelControlButtons();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        ((Container)verticalLayoutPanel).add(this.sodiumGatedChannelControlButton);
        ((Container)verticalLayoutPanel).add(this.createVerticalSpacingPanel(15));
        ((Container)verticalLayoutPanel).add(this.potassiumGatedChannelControlButton);
        this.addControlFullWidth(this.createVerticalSpacingPanel(15));
        this.addControl(verticalLayoutPanel);
        this.addControl(this.createVerticalSpacingPanel(15));
        JPanel jPanel = new JPanel();
        this.clearParticlesButton = new JButton(MembraneChannelsStrings.CLEAR_PARTICLES);
        this.clearParticlesButton.setPreferredSize(dimension);
        this.clearParticlesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                membraneChannelsModel.removeAllParticles();
            }
        });
        jPanel.add(this.clearParticlesButton);
        this.addControlFullWidth(jPanel);
        this.updateClearParticlesButton();
        this.addControlFullWidth(this.createVerticalSpacingPanel(15));
        JPanel jPanel2 = new JPanel();
        this.showConcentrationsCheckBox = new JCheckBox(MembraneChannelsStrings.SHOW_CONCENTRATIONS);
        this.showConcentrationsCheckBox.setFont(MembraneChannelsConstants.CONTROL_PANEL_CONTROL_FONT);
        this.showConcentrationsCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                membraneChannelsModel.setConcentrationGraphsVisible(MembraneChannelsControlPanel.this.showConcentrationsCheckBox.isSelected());
            }
        });
        this.showConcentrationsCheckBox.setAlignmentX(0.5f);
        jPanel2.add(this.showConcentrationsCheckBox);
        this.addControlFullWidth(jPanel2);
        this.updateConcentrationsCheckBoxState();
        this.addControlFullWidth(this.createVerticalSpacingPanel(70));
        this.addResetAllButton(piccoloModule);
    }

    private JPanel createVerticalSpacingPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(n));
        return jPanel;
    }

    private void updateConcentrationsCheckBoxState() {
        this.showConcentrationsCheckBox.setSelected(this.model.isConcentrationGraphsVisible());
    }

    private void updateMembraneChannelControlButtons() {
        this.sodiumGatedChannelControlButton.setEnabled(this.model.getNumGatedSodiumChannels() > 0);
        this.potassiumGatedChannelControlButton.setEnabled(this.model.getNumGatedPotassiumChannels() > 0);
        this.sodiumGatedChannelControlButton.setIcon(new ChannelControlButtonIcon(MembraneChannelTypes.SODIUM_GATED_CHANNEL, this.model.getGatedSodiumChannelOpenness() > 0.5));
        this.potassiumGatedChannelControlButton.setIcon(new ChannelControlButtonIcon(MembraneChannelTypes.POTASSIUM_GATED_CHANNEL, this.model.getGatedPotassiumChannelOpenness() > 0.5));
    }

    private void updateClearParticlesButton() {
        this.clearParticlesButton.setEnabled(this.model.getParticles().size() > 0);
    }

    private static class ChannelControlButtonIcon
    extends ImageIcon {
        ChannelControlButtonIcon(MembraneChannelTypes membraneChannelTypes, boolean bl) {
            String string;
            String string2;
            ParticleNode particleNode;
            ModelViewTransform2D modelViewTransform2D = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 0.0), 7.0, false);
            if (membraneChannelTypes == MembraneChannelTypes.POTASSIUM_GATED_CHANNEL) {
                particleNode = new ParticleNode(new PotassiumIon(), modelViewTransform2D);
                if (bl) {
                    string2 = "blue_gate_close_icon.png";
                    string = MembraneChannelsStrings.CLOSE;
                } else {
                    string2 = "blue_gate_open_icon.png";
                    string = MembraneChannelsStrings.OPEN;
                }
            } else {
                particleNode = new ParticleNode(new SodiumIon(), modelViewTransform2D);
                if (bl) {
                    string2 = "green_gate_close_icon.png";
                    string = MembraneChannelsStrings.CLOSE;
                } else {
                    string2 = "green_gate_open_icon.png";
                    string = MembraneChannelsStrings.OPEN;
                }
            }
            final PImage pImage = new PImage(MembraneChannelsResources.getImage(string2));
            final PText pText = new PText(string){
                {
                    this.setFont(new PhetFont(12));
                }
            };
            final PText pText2 = new PText(MembraneChannelsStrings.CHANNELS){
                {
                    this.setFont(new PhetFont(12));
                }
            };
            PNode pNode = new PNode(){
                {
                    this.addChild(pImage);
                    pText.setOffset(pImage.getFullBoundsReference().getMaxX() + 4.0, pImage.getFullBoundsReference().getCenterY() - pText.getFullBoundsReference().height / 2.0);
                    this.addChild(pText);
                    particleNode.setOffset(pText.getFullBoundsReference().getMaxX() + 10.0, pImage.getFullBoundsReference().getCenterY());
                    this.addChild(particleNode);
                    pText2.setOffset(particleNode.getFullBoundsReference().getMaxX() + 4.0, pImage.getFullBoundsReference().getCenterY() - pText2.getFullBoundsReference().height / 2.0);
                    this.addChild(pText2);
                }
            };
            this.setImage(pNode.toImage());
        }
    }

    private static class MembraneChannelRemovalListener
    extends MembraneChannel.Adapter {
        private final MembraneChannel membraneChannel;
        private final MembraneChannelsControlPanel membraneChannelsControlPanel;

        public MembraneChannelRemovalListener(MembraneChannel membraneChannel, MembraneChannelsControlPanel membraneChannelsControlPanel) {
            this.membraneChannel = membraneChannel;
            this.membraneChannelsControlPanel = membraneChannelsControlPanel;
        }

        public void removed() {
            this.membraneChannelsControlPanel.updateMembraneChannelControlButtons();
            this.membraneChannel.removeListener(this);
        }
    }

    private static class ParticleRemovalListener
    extends Particle.Adapter {
        private final Particle particle;
        private final MembraneChannelsControlPanel membraneChannelsControlPanel;

        public ParticleRemovalListener(Particle particle, MembraneChannelsControlPanel membraneChannelsControlPanel) {
            this.particle = particle;
            this.membraneChannelsControlPanel = membraneChannelsControlPanel;
        }

        public void removedFromModel() {
            this.particle.removeListener(this);
            this.membraneChannelsControlPanel.updateClearParticlesButton();
        }
    }
}

