/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.mediabuttons;

import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.IconButton;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.util.ArrayList;

public class DefaultIconButton
extends IconButton {
    protected PhetPPath iconNode;
    private ArrayList listeners = new ArrayList();

    public DefaultIconButton(int n, Shape shape) {
        super(n);
        this.iconNode = new PhetPPath(shape, Color.BLACK, new BasicStroke(1.0f), Color.LIGHT_GRAY);
        this.addChild(this.iconNode);
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        this.addInputEventListener(buttonEventHandler);
        buttonEventHandler.addButtonEventListener(new ButtonEventHandler.ButtonEventAdapter(){

            public void fire() {
                DefaultIconButton.this.notifyListeners();
            }
        });
    }

    protected void updateImage() {
        super.updateImage();
        this.iconNode.setPaint(this.isEnabled() ? Color.black : Color.gray);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).buttonPressed();
        }
    }

    public static interface Listener {
        public void buttonPressed();
    }
}

