/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.clock;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Color;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;

public class TimeSpeedSlider
extends VerticalLayoutPanel {
    private final LinearValueControl linearSlider;

    public TimeSpeedSlider(double d, double d2, String string, ConstantDtClock constantDtClock) {
        this(d, d2, string, constantDtClock, PhetCommonResources.getString("Common.sim.speed"));
    }

    public TimeSpeedSlider(double d, double d2, String string, ConstantDtClock constantDtClock, String string2) {
        this(d, d2, string, constantDtClock, string2, Color.BLACK);
    }

    public TimeSpeedSlider(double d, double d2, String string, final ConstantDtClock constantDtClock, String string2, Color color) {
        this.linearSlider = new LinearValueControl(d, d2, "", string, "");
        this.linearSlider.setTextFieldVisible(false);
        Hashtable<Double, TimeSpeederLabel> hashtable = new Hashtable<Double, TimeSpeederLabel>();
        hashtable.put(new Double(d), new TimeSpeederLabel(PhetCommonResources.getString("Common.time.slow"), color));
        hashtable.put(new Double(d2), new TimeSpeederLabel(PhetCommonResources.getString("Common.time.fast"), color));
        TimeSpeederLabel timeSpeederLabel = new TimeSpeederLabel(string2, color);
        timeSpeederLabel.setFont(new PhetFont(2, PhetFont.getDefaultFontSize()));
        hashtable.put(new Double((d2 + d) / 2.0), timeSpeederLabel);
        this.linearSlider.setTickLabels(hashtable);
        constantDtClock.addConstantDtClockListener(new ConstantDtClock.ConstantDtClockAdapter(){

            public void dtChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
                TimeSpeedSlider.this.update(constantDtClock);
            }
        });
        this.update(constantDtClock);
        this.add(this.linearSlider);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.linearSlider.addChangeListener(changeListener);
    }

    private void update(ConstantDtClock constantDtClock) {
        this.linearSlider.setValue(constantDtClock.getTimingStrategy().getSimulationTimeChangeForPausedClock());
    }

    public double getValue() {
        return this.linearSlider.getValue();
    }

    private static class TimeSpeederLabel
    extends JLabel {
        public TimeSpeederLabel(String string, Color color) {
            super(string);
            this.setForeground(color);
        }
    }
}

