/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleManager;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.dialogs.PhetAboutDialog;
import edu.colorado.phet.common.phetcommon.util.CommandLineUtils;
import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.common.phetcommon.view.ITabbedModulePane;
import edu.colorado.phet.common.phetcommon.view.JTabbedModulePane;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

public class PhetApplication
implements IProguardKeepClass {
    public static final String DEVELOPER_CONTROLS_COMMAND_LINE_ARG = "-dev";
    private static ArrayList<PhetApplication> phetApplications = new ArrayList();
    private ITabbedModulePane tabbedModulePane;
    private PhetApplicationConfig phetApplicationConfig;
    private PhetFrame phetFrame;
    private ModuleManager moduleManager;
    private PhetAboutDialog aboutDialog;
    private boolean applicationStarted = false;

    public PhetApplication(PhetApplicationConfig phetApplicationConfig) {
        this(phetApplicationConfig, new JTabbedModulePane());
    }

    protected PhetApplication(PhetApplicationConfig phetApplicationConfig, ITabbedModulePane iTabbedModulePane) {
        this.phetApplicationConfig = phetApplicationConfig;
        this.tabbedModulePane = iTabbedModulePane;
        this.moduleManager = new ModuleManager(this);
        this.phetFrame = this.createPhetFrame();
        phetApplicationConfig.getFrameSetup().initialize(this.phetFrame);
        this.parseArgs(phetApplicationConfig.getCommandLineArgs());
        phetApplications.add(this);
    }

    public ITabbedModulePane getTabbedModulePane() {
        return this.tabbedModulePane;
    }

    public boolean isDeveloperControlsEnabled() {
        return CommandLineUtils.contains(this.phetApplicationConfig.getCommandLineArgs(), DEVELOPER_CONTROLS_COMMAND_LINE_ARG);
    }

    public ISimInfo getSimInfo() {
        return this.phetApplicationConfig;
    }

    public static PhetApplication getInstance() {
        return phetApplications.get(phetApplications.size() - 1);
    }

    protected PhetFrame createPhetFrame() {
        return new PhetFrame(this);
    }

    protected void parseArgs(String[] stringArray) {
    }

    public void startApplication() {
        if (!this.applicationStarted) {
            this.applicationStarted = true;
            if (this.moduleManager.numModules() == 0) {
                throw new RuntimeException("No modules in module manager");
            }
            this.phetFrame.addWindowFocusListener(new WindowAdapter(){

                public void windowGainedFocus(WindowEvent windowEvent) {
                    PhetApplication.this.initializeModuleReferenceSizes();
                    PhetApplication.this.phetFrame.removeWindowFocusListener(this);
                }
            });
            this.moduleManager.setActiveModule(this.getStartModule());
            this.phetFrame.setVisible(true);
            this.updateLogoVisibility();
        } else {
            System.out.println("WARNING: PhetApplication.startApplication was called more than once.");
        }
    }

    protected void updateLogoVisibility() {
        for (int i = 0; i < this.moduleManager.numModules(); ++i) {
            if (!this.moduleAt(i).isLogoPanelVisible() || this.phetFrame.getTabbedModulePane() == null || !this.phetFrame.getTabbedModulePane().getLogoVisible()) continue;
            this.moduleAt(i).setLogoPanelVisible(false);
        }
    }

    private void initializeModuleReferenceSizes() {
        for (int i = 0; i < this.moduleManager.numModules(); ++i) {
            this.moduleManager.moduleAt(i).setReferenceSize();
        }
    }

    public PhetFrame getPhetFrame() {
        return this.phetFrame;
    }

    public void setModules(Module[] moduleArray) {
        this.moduleManager.setModules(moduleArray);
    }

    public void removeModule(Module module) {
        this.moduleManager.removeModule(module);
    }

    public void addModule(Module module) {
        this.moduleManager.addModule(module);
    }

    public Module moduleAt(int n) {
        return this.moduleManager.moduleAt(n);
    }

    public Module getModule(int n) {
        return this.moduleAt(n);
    }

    public void setActiveModule(Module module) {
        this.moduleManager.setActiveModule(module);
    }

    public void setActiveModule(int n) {
        this.moduleManager.setActiveModule(n);
    }

    public Module getStartModule() {
        return this.moduleManager.getStartModule();
    }

    public void setStartModule(Module module) {
        this.moduleManager.setStartModule(module);
    }

    public void addModuleObserver(ModuleObserver moduleObserver) {
        this.moduleManager.addModuleObserver(moduleObserver);
    }

    public void removeModuleObserver(ModuleObserver moduleObserver) {
        this.moduleManager.removeModuleObserver(moduleObserver);
    }

    public int indexOf(Module module) {
        return this.moduleManager.indexOf(module);
    }

    public int numModules() {
        return this.moduleManager.numModules();
    }

    public Module getActiveModule() {
        return this.moduleManager.getActiveModule();
    }

    public void addModules(Module[] moduleArray) {
        for (int i = 0; i < moduleArray.length; ++i) {
            this.addModule(moduleArray[i]);
        }
    }

    public Module[] getModules() {
        return this.moduleManager.getModules();
    }

    public void pause() {
        this.getActiveModule().deactivate();
    }

    public void resume() {
        this.getActiveModule().activate();
    }

    public void showAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new PhetAboutDialog(this);
            this.aboutDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PhetApplication.this.aboutDialog.dispose();
                }

                public void windowClosed(WindowEvent windowEvent) {
                    PhetApplication.this.aboutDialog = null;
                }
            });
            this.aboutDialog.setVisible(true);
        }
    }

    public void setControlPanelBackground(Color color) {
        for (Module module : this.getModules()) {
            module.setControlPanelBackground(color);
            module.setClockControlPanelBackground(color);
            module.setHelpPanelBackground(color);
        }
    }

    public void save() {
    }

    public void load() {
    }
}

