/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.piccolophet.nodes.ZoomControlNode;
import edu.colorado.phet.eatingandexercise.view.SparseStackedBarChartAxisNode;
import edu.colorado.phet.eatingandexercise.view.StackedBarNode;
import edu.umd.cs.piccolo.PNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class StackedBarChartNode
extends PNode {
    private PNode barLayer = new PNode();
    private Function.LinearFunction function;
    private String title;
    private int spacing;
    private double minorTickSpacing;
    private double majorTickSpacing;
    private double maxYValue;
    private SparseStackedBarChartAxisNode axisNode;
    private ZoomControlNode zoomControlNode = new ZoomControlNode(1);
    private double defaultMaxOutValue;
    private double defaultMaxInValue;

    public StackedBarChartNode(Function.LinearFunction linearFunction, String string, int n, double d, double d2, double d3) {
        this.function = linearFunction;
        this.title = string;
        this.spacing = n;
        this.minorTickSpacing = d;
        this.majorTickSpacing = d2;
        this.maxYValue = d3;
        this.defaultMaxInValue = linearFunction.getMaxInput();
        this.defaultMaxOutValue = linearFunction.getMaxOutput();
        this.addChild(this.barLayer);
        this.axisNode = new SparseStackedBarChartAxisNode(string, linearFunction, d, d2, d3);
        this.addChild(this.axisNode);
        this.zoomControlNode.addZoomListener(new ZoomControlNode.ZoomListener(){

            public void zoomedOut() {
                Function.LinearFunction linearFunction = StackedBarChartNode.this.function;
                StackedBarChartNode.this.setFunction(new Function.LinearFunction(linearFunction.getMinInput(), linearFunction.getMaxInput(), linearFunction.getMinOutput(), linearFunction.getMaxOutput() / 2.0));
            }

            public void zoomedIn() {
                Function.LinearFunction linearFunction = StackedBarChartNode.this.function;
                StackedBarChartNode.this.setFunction(new Function.LinearFunction(linearFunction.getMinInput(), linearFunction.getMaxInput(), linearFunction.getMinOutput(), linearFunction.getMaxOutput() * 2.0));
            }
        });
        this.addChild(this.zoomControlNode);
        this.updateLayout();
    }

    public PNode getAxisNode() {
        return this.axisNode;
    }

    public void setFunction(Function.LinearFunction linearFunction) {
        this.function = linearFunction;
        this.removeChild(this.axisNode);
        this.axisNode = new SparseStackedBarChartAxisNode(this.title, linearFunction, this.minorTickSpacing, this.majorTickSpacing, this.maxYValue);
        this.addChild(this.indexOfChild(this.barLayer) + 1, this.axisNode);
        for (int i = 0; i < this.barLayer.getChildrenCount(); ++i) {
            PNode pNode = this.barLayer.getChild(i);
            if (!(pNode instanceof StackedBarNode)) continue;
            ((StackedBarNode)pNode).setFunction(linearFunction);
        }
        this.updateLayout();
    }

    public void addStackedBarNode(StackedBarNode stackedBarNode) {
        this.barLayer.addChild(stackedBarNode);
        stackedBarNode.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                StackedBarChartNode.this.updateZoomVisibility();
            }
        });
        this.updateLayout();
    }

    private void updateZoomVisibility() {
        boolean bl = this.anyBarTooLarge();
        if (!bl) {
            if (this.isAtDefaultZoom()) {
                this.zoomControlNode.setVisible(false);
                this.zoomControlNode.setPickable(false);
                this.zoomControlNode.setChildrenPickable(false);
            }
        } else {
            this.zoomControlNode.setVisible(true);
            this.zoomControlNode.setPickable(true);
            this.zoomControlNode.setChildrenPickable(true);
        }
    }

    private boolean anyBarTooLarge() {
        boolean bl = false;
        for (int i = 0; i < this.barLayer.getChildrenCount(); ++i) {
            PNode pNode = this.barLayer.getChild(i);
            if (!(pNode instanceof StackedBarNode)) continue;
            StackedBarNode stackedBarNode = (StackedBarNode)pNode;
            bl = bl || stackedBarNode.getTotal() >= 4000.0;
        }
        return bl;
    }

    private boolean isAtDefaultZoom() {
        return MathUtil.isApproxEqual(this.defaultMaxInValue, this.function.getMaxInput(), 1.0E-6) && MathUtil.isApproxEqual(this.defaultMaxOutValue, this.function.getMaxOutput(), 1.0E-6);
    }

    public String getTitle() {
        return this.title;
    }

    public void resetAll() {
        this.setFunction(new Function.LinearFunction(this.function.getMinInput(), this.defaultMaxInValue, this.function.getMinOutput(), this.defaultMaxOutValue));
    }

    private void updateLayout() {
        if (this.barLayer.getChildrenCount() >= 1) {
            StackedBarNode stackedBarNode = (StackedBarNode)this.barLayer.getChild(0);
            stackedBarNode.setOffset(0.0, 0.0);
            double d = stackedBarNode.getFullBounds().getMaxX() - this.axisNode.getFullBounds().getX();
            this.axisNode.offset(d + 2.0, 0.0);
            this.zoomControlNode.setOffset(this.axisNode.getFullBounds().getCenterX() + this.zoomControlNode.getFullBounds().getWidth() / 4.0, this.axisNode.getFullBounds().getMaxY() - this.zoomControlNode.getFullBounds().getHeight() * 1.1);
            double d2 = this.axisNode.getFullBounds().getMaxX() + 2.0;
            for (int i = 1; i < this.barLayer.getChildrenCount(); ++i) {
                StackedBarNode stackedBarNode2 = (StackedBarNode)this.barLayer.getChild(i);
                stackedBarNode2.setOffset(d2, 0.0);
                d2 += stackedBarNode2.getBarWidth() + (double)this.spacing;
            }
        }
        this.updateZoomVisibility();
    }
}

