/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.view.BarChartElement;
import edu.colorado.phet.eatingandexercise.view.StackedBarNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class BarChartElementNode
extends PNode {
    private BarChartElement barChartElement;
    private PClip clip;
    private PhetPPath barNode;
    private PhetPPath barThumb;
    private StackedBarNode.Thumb thumbLocation;
    private PNode imageNode;
    private HTMLNode textNode;
    private HTMLNode valueNode;
    private StackedBarNode stackedBarNode;

    public BarChartElementNode(final StackedBarNode stackedBarNode, final BarChartElement barChartElement, StackedBarNode.Thumb thumb) {
        this.stackedBarNode = stackedBarNode;
        this.thumbLocation = thumb;
        this.barChartElement = barChartElement;
        this.barNode = new PhetPPath((Shape)this.createShape(), barChartElement.getPaint());
        this.addChild(this.barNode);
        barChartElement.addListener(new BarChartElement.Listener(){

            public void valueChanged() {
                BarChartElementNode.this.updateShape();
            }
        });
        this.clip = new PClip();
        this.imageNode = barChartElement.getImage() != null ? new PImage(BufferedImageUtils.multiScaleToWidth(barChartElement.getImage(), 35)) : new PNode();
        PhetFont phetFont = new PhetFont(14, true);
        this.textNode = new HTMLNode(barChartElement.getName(), barChartElement.getTextColor(), phetFont);
        this.valueNode = new HTMLNode("", barChartElement.getTextColor(), phetFont);
        this.clip.addChild(this.imageNode);
        this.clip.addChild(this.textNode);
        this.clip.addChild(this.valueNode);
        this.addChild(this.clip);
        this.barThumb = new PhetPPath(thumb.getThumbShape(stackedBarNode.getBarWidth()), barChartElement.getPaint(), new BasicStroke(1.0f), Color.black);
        this.addChild(this.barThumb);
        this.barThumb.addInputEventListener(new CursorHandler());
        this.barThumb.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                double d = stackedBarNode.viewToModelDelta(pInputEvent.getCanvasDelta().getHeight());
                barChartElement.setValue(Math.max(0.0, barChartElement.getValue() - d));
            }
        });
        this.updateShape();
    }

    public void updateShape() {
        double d = this.barChartElement.getValue();
        this.valueNode.setHTML(EatingAndExerciseStrings.KCAL_PER_DAY_FORMAT.format(d));
        this.barNode.setPathTo(this.createShape());
        this.clip.setPathTo(this.createShape());
        double d2 = this.clip.getFullBounds().getHeight();
        this.textNode.setOffset(0.0, 0.0);
        this.imageNode.setOffset(this.clip.getFullBounds().getWidth() / 2.0 - this.imageNode.getFullBounds().getWidth() / 2.0, 0.0);
        this.textNode.setOffset(this.clip.getFullBounds().getWidth() / 2.0 - this.textNode.getFullBounds().getWidth() / 2.0, this.imageNode.getFullBounds().getHeight() - 3.0);
        this.valueNode.setOffset(this.clip.getFullBounds().getWidth() / 2.0 - this.valueNode.getFullBounds().getWidth() / 2.0 + 2.0, this.textNode.getFullBounds().getMaxY() - 2.0);
        this.valueNode.setScale(1.0);
        this.imageNode.setVisible(true);
        this.imageNode.setOffset(1.0, 0.0);
        double d3 = (this.clip.getFullBounds().getMaxX() + this.imageNode.getFullBounds().getMaxX()) / 2.0 - this.textNode.getFullBounds().getWidth() / 2.0;
        this.textNode.setOffset(d3, 0.0);
        this.valueNode.setOffset(this.textNode.getFullBounds().getCenterX() - this.valueNode.getFullBounds().getWidth() / 2.0, this.textNode.getFullBounds().getMaxY());
        double d4 = (this.textNode.getFullBounds().getY() + this.valueNode.getFullBounds().getMaxY()) / 2.0 - this.imageNode.getFullBounds().getHeight() / 2.0;
        this.imageNode.setOffset(1.0, d4);
        if (this.valueNode.getFullBounds().getMaxY() > d2) {
            this.imageNode.setVisible(false);
            this.textNode.setOffset(2.0, 0.0);
            this.valueNode.setOffset(this.clip.getFullBounds().getMaxX() - this.valueNode.getFullBounds().getWidth() - 2.0, 0.0);
        }
        this.barThumb.setPathTo(this.thumbLocation.getThumbShape(this.stackedBarNode.getBarWidth()));
    }

    private Rectangle2D.Double createShape() {
        return new Rectangle2D.Double(0.0, 0.0, this.stackedBarNode.getBarWidth(), this.stackedBarNode.modelToView(this.barChartElement.getValue()));
    }

    public BarChartElement getBarChartElement() {
        return this.barChartElement;
    }
}

