/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class BarChartElement {
    private String name;
    private Paint paint;
    private double value;
    private BufferedImage image;
    private Color textColor;
    private ArrayList listeners = new ArrayList();

    public BarChartElement(String string, Paint paint, double d, BufferedImage bufferedImage, Color color) {
        this.name = string;
        this.paint = paint;
        this.value = d;
        this.image = bufferedImage;
        this.textColor = color;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        if (!this.equals(this.value, d)) {
            this.value = d;
            this.notifyListener();
        }
    }

    private boolean equals(double d, double d2) {
        return d == d2 || Double.isNaN(d) && Double.isNaN(d2);
    }

    public String getName() {
        return this.name;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListener() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).valueChanged();
        }
    }

    public static interface Listener {
        public void valueChanged();
    }
}

