/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.util;

import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.control.ExerciseItem;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.CaloricFoodItem;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class EatingAndExerciseFileParser {
    public static CaloricFoodItem[] getFoodItems(Human human) {
        return (CaloricFoodItem[])EatingAndExerciseFileParser.parse("foods.properties", new FoodItemParser(), new CaloricFoodItem[0], human);
    }

    public static CaloricItem[] getExerciseItems(Human human) {
        return (CaloricItem[])EatingAndExerciseFileParser.parse("exercise.properties", new ExerciseItemParser(), new CaloricItem[0], human);
    }

    private static Object[] parse(String string, IParser iParser, Object[] objectArray, Human human) {
        try {
            double d = 0.0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(EatingAndExerciseResources.getResourceLoader().getResourceAsStream(string)));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!(string2 = string2.trim()).startsWith("#") && string2.length() > 0) {
                    if (string2.startsWith("reference-weight-pounds")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, "=");
                        stringTokenizer.nextToken();
                        d = Double.parseDouble(stringTokenizer.nextToken());
                    } else {
                        arrayList.add(iParser.parseLine(string2, d, human));
                    }
                }
                string2 = bufferedReader.readLine();
            }
            return arrayList.toArray(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class ExerciseItemParser
    implements IParser {
        private ExerciseItemParser() {
        }

        public Object parseLine(String string, double d, Human human) {
            String string2 = string.substring(0, string.indexOf(":"));
            String string3 = string.substring(string.indexOf(":") + 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            double d2 = Double.parseDouble(stringTokenizer.nextToken()) / 4.0;
            double d3 = Double.parseDouble(stringTokenizer.nextToken());
            String string4 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken().trim();
            }
            return new ExerciseItem(EatingAndExerciseResources.getString("fifteen.minutes") + " " + EatingAndExerciseResources.getString(string2), string4, d2, d3, d, human);
        }
    }

    private static class FoodItemParser
    implements IParser {
        private FoodItemParser() {
        }

        public Object parseLine(String string, double d, Human human) {
            String string2 = string.substring(0, string.indexOf(":"));
            String string3 = string.substring(string.indexOf(":") + 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            double d2 = Double.parseDouble(stringTokenizer.nextToken());
            double d3 = Double.parseDouble(stringTokenizer.nextToken());
            double d4 = Double.parseDouble(stringTokenizer.nextToken());
            double d5 = Double.parseDouble(stringTokenizer.nextToken());
            String string4 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken().trim();
            }
            return new CaloricFoodItem(EatingAndExerciseResources.getString(string2), string4, d3, d4, d5);
        }
    }

    private static interface IParser {
        public Object parseLine(String var1, double var2, Human var4);
    }
}

