/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.module.eatingandexercise;

import edu.colorado.phet.common.phetcommon.dialogs.ColorChooserFactory;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseConstants;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.control.CaloriePanel;
import edu.colorado.phet.eatingandexercise.control.ChartNode;
import edu.colorado.phet.eatingandexercise.control.HumanControlPanel;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.AgeRangeMessage;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.BMIHelpButtonNode;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.BMIReadout;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseModel;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseRenderingSizeStrategy;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.HeartAttackMessage;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.StarvingMessage;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.TimeoutWarningMessage;
import edu.colorado.phet.eatingandexercise.view.EatingAndExerciseColorScheme;
import edu.colorado.phet.eatingandexercise.view.HealthIndicator;
import edu.colorado.phet.eatingandexercise.view.HumanNode;
import edu.colorado.phet.eatingandexercise.view.ScaleNode;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class EatingAndExerciseCanvas
extends BufferedPhetPCanvas {
    private EatingAndExerciseModel _model;
    private PNode _rootNode;
    private PSwing humanControlPanelPSwing;
    private HumanNode humanAreaNode;
    private BMIHelpButtonNode heartHealthButtonNode;
    private CaloriePanel caloriePanel;
    private BMIReadout bmiReadout;
    private TimeoutWarningMessage ageRangeMessage;
    private HumanControlPanel humanControlPanel;
    private StarvingMessage starvingMessage;
    private HeartAttackMessage heartAttackMessage;
    private HealthIndicator healthIndicator;
    private PhetPPath playAreaBackgroundNode;
    private boolean showColorChooser = false;

    public EatingAndExerciseCanvas(EatingAndExerciseModel eatingAndExerciseModel, Frame frame) {
        super(new PDimension(15.0, 15.0));
        this._model = eatingAndExerciseModel;
        this.setBackground(EatingAndExerciseConstants.BACKGROUND);
        if (this.showColorChooser) {
            this.showColorChooser(frame);
        }
        this._rootNode = new PNode();
        this._rootNode.addChild(new ScaleNode(eatingAndExerciseModel, eatingAndExerciseModel.getHuman()));
        this.humanAreaNode = new HumanNode(eatingAndExerciseModel.getHuman());
        this.humanAreaNode.addListener(new HumanNode.Listener(){

            public void infoButtonPressed() {
                PhetOptionPane.showMessageDialog(EatingAndExerciseCanvas.this, EatingAndExerciseResources.getString("heart.health.info"));
            }
        });
        this.playAreaBackgroundNode = new PhetPPath(EatingAndExerciseColorScheme.getBackgroundColor(), (Stroke)new BasicStroke(2.0f), (Paint)Color.gray);
        this.addScreenChild(this.playAreaBackgroundNode);
        this.addWorldChild(this._rootNode);
        this._rootNode.addChild(this.humanAreaNode);
        this.bmiReadout = new BMIReadout(eatingAndExerciseModel.getHuman());
        this.heartHealthButtonNode = new BMIHelpButtonNode(this, eatingAndExerciseModel.getHuman());
        this.updateHeartHealthButtonNodeLayout();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                EatingAndExerciseCanvas.this.updateHeartHealthButtonNodeLayout();
            }
        });
        eatingAndExerciseModel.getHuman().addListener(new Human.Adapter(){

            public void heightChanged() {
                EatingAndExerciseCanvas.this.updateHeartHealthButtonNodeLayout();
            }
        });
        this.humanControlPanel = new HumanControlPanel(this, eatingAndExerciseModel, eatingAndExerciseModel.getHuman());
        this.humanControlPanel.addListener(new HumanControlPanel.Listener(){

            public void ageManuallyChanged() {
                EatingAndExerciseCanvas.this.caloriePanel.clearAndResetDomains();
            }
        });
        this.humanControlPanelPSwing = new PSwing(this.humanControlPanel);
        this.addScreenChild(this.humanControlPanelPSwing);
        this.healthIndicator = new HealthIndicator(eatingAndExerciseModel.getHuman());
        this.addScreenChild(this.healthIndicator);
        this.caloriePanel = new CaloriePanel(eatingAndExerciseModel, this, frame);
        this.addScreenChild(this.caloriePanel);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                EatingAndExerciseCanvas.this.requestFocus();
            }
        });
        this.setWorldTransformStrategy(new EatingAndExerciseRenderingSizeStrategy(this));
        this.ageRangeMessage = new AgeRangeMessage(eatingAndExerciseModel.getHuman());
        this.starvingMessage = new StarvingMessage(eatingAndExerciseModel.getHuman());
        this.addScreenChild(this.starvingMessage);
        this.heartAttackMessage = new HeartAttackMessage(eatingAndExerciseModel.getHuman());
        this.addScreenChild(this.heartAttackMessage);
        this.updateLayout();
    }

    private void showColorChooser(final Frame frame) {
        this.getCamera().addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                if (pInputEvent.isLeftMouseButton() && pInputEvent.getPickedNode() instanceof PCamera) {
                    ColorChooserFactory.showDialog("background color", frame, EatingAndExerciseCanvas.this.getBackground(), new ColorChooserFactory.Listener(){

                        public void colorChanged(Color color) {
                            EatingAndExerciseCanvas.this.setBackground(color);
                        }

                        public void ok(Color color) {
                            EatingAndExerciseCanvas.this.setBackground(color);
                        }

                        public void cancelled(Color color) {
                            EatingAndExerciseCanvas.this.setBackground(color);
                        }
                    }, true);
                }
            }
        });
    }

    private void updateHeartHealthButtonNodeLayout() {
        Point2D point2D = this.humanAreaNode.getHeartNode().getGlobalFullBounds().getOrigin();
        point2D.setLocation(point2D.getX() + this.humanAreaNode.getHeartNode().getGlobalFullBounds().getWidth(), point2D.getY() + 5.0);
        this.bmiReadout.setOffset(point2D);
        this.heartHealthButtonNode.setOffset(this.bmiReadout.getFullBounds().getX(), this.bmiReadout.getFullBounds().getMaxY());
    }

    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() <= 0.0 || dimension2D.getHeight() <= 0.0) {
            return;
        }
        this.humanControlPanelPSwing.setOffset(0.0, (double)this.getHeight() - this.humanControlPanelPSwing.getFullBounds().getHeight());
        this.ageRangeMessage.setOffset(this.humanControlPanelPSwing.getFullBounds().getMaxX(), this.humanControlPanelPSwing.getFullBounds().getY() + this.humanControlPanel.getAgeSliderY());
        this.starvingMessage.setOffset(this.humanAreaNode.getGlobalFullBounds().getCenterX() - this.starvingMessage.getFullBounds().getWidth() / 2.0, this.humanAreaNode.getGlobalFullBounds().getCenterY());
        this.heartAttackMessage.setOffset(this.starvingMessage.getFullBounds().getX(), this.starvingMessage.getFullBounds().getMaxY());
        this.updateHealthIndicatorLocation();
        this.caloriePanel.setOffset(this.humanControlPanelPSwing.getFullBounds().getWidth(), 0.0);
        this.playAreaBackgroundNode.setPathToRectangle(0.0f, 0.0f, (float)this.humanControlPanelPSwing.getFullBounds().getWidth(), this.getHeight());
    }

    private void updateHealthIndicatorLocation() {
        this.healthIndicator.setOffset(5.0, this.humanControlPanelPSwing.getFullBounds().getMinY() - this.healthIndicator.getFullBounds().getHeight());
        Point2D point2D = this.humanAreaNode.getGlobalFullBounds().getCenter2D();
        this.healthIndicator.setOffset(5.0, point2D.getY());
    }

    public double getControlPanelWidth() {
        return this.humanControlPanelPSwing.getFullBounds().getWidth();
    }

    public void resetAll() {
        this.caloriePanel.resetAll();
    }

    public void applicationStarted() {
        this.caloriePanel.applicationStarted();
    }

    public void addEditorClosedListener(ActionListener actionListener) {
        this.caloriePanel.addEditorClosedListener(actionListener);
    }

    public double getAvailableWorldHeight() {
        return (double)this.getHeight() - this.humanControlPanelPSwing.getFullBounds().getHeight();
    }

    public double getAvailableWorldWidth() {
        return this.humanControlPanelPSwing.getFullBounds().getWidth() * 1.1;
    }

    public double getControlPanelY() {
        return this.humanControlPanelPSwing.getFullBounds().getY();
    }

    public void addFoodPressedListener(ActionListener actionListener) {
        this.caloriePanel.addFoodPressedListener(actionListener);
    }

    public PNode getPlateNode() {
        return this.caloriePanel.getPlateNode();
    }

    public void addExerciseDraggedListener(ActionListener actionListener) {
        this.caloriePanel.addExerciseDraggedListener(actionListener);
    }

    public PNode getDiaryNode() {
        return this.caloriePanel.getDiaryNode();
    }

    public ChartNode getChartNode() {
        return this.caloriePanel.getChartNode();
    }
}

