/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.model;

import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.CaloricFoodItem;
import java.util.ArrayList;

public class CalorieSet {
    private ArrayList list = new ArrayList();
    private ArrayList listeners = new ArrayList();

    public CalorieSet() {
    }

    public CalorieSet(CaloricItem[] caloricItemArray) {
        for (int i = 0; i < caloricItemArray.length; ++i) {
            this.addItem(caloricItemArray[i]);
        }
    }

    public void insertItem(int n, CaloricItem caloricItem) {
        this.list.add(n, caloricItem);
        this.notifyItemAdded(caloricItem);
    }

    public void addItem(final CaloricItem caloricItem) {
        this.list.add(caloricItem);
        this.notifyItemAdded(caloricItem);
        caloricItem.addListener(new CaloricItem.Listener(){

            public void caloriesChanged() {
                CalorieSet.this.notifyItemChanged(caloricItem);
            }
        });
    }

    private void notifyItemChanged(CaloricItem caloricItem) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).itemChanged(caloricItem);
        }
    }

    public double getTotalCalories() {
        double d = 0.0;
        for (int i = 0; i < this.list.size(); ++i) {
            d += ((CaloricItem)this.list.get(i)).getCalories();
        }
        return d;
    }

    public int size() {
        return this.list.size();
    }

    public CaloricItem getItem(int n) {
        return (CaloricItem)this.list.get(n);
    }

    public int getItemCount() {
        return this.size();
    }

    public void removeItem(CaloricItem caloricItem) {
        this.list.remove(caloricItem);
        this.notifyItemRemoved(caloricItem);
    }

    private void notifyItemRemoved(CaloricItem caloricItem) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).itemRemoved(caloricItem);
        }
    }

    public void clear() {
        while (this.getItemCount() > 0) {
            this.removeItem(this.getItem(0));
        }
    }

    public void removeAll(CaloricFoodItem[] caloricFoodItemArray) {
        for (int i = 0; i < caloricFoodItemArray.length; ++i) {
            this.removeItem(caloricFoodItemArray[i]);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyItemAdded(CaloricItem caloricItem) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).itemAdded(caloricItem);
        }
    }

    public boolean contains(CaloricItem caloricItem) {
        return this.list.contains(caloricItem);
    }

    public static class Adapter
    implements Listener {
        public void itemAdded(CaloricItem caloricItem) {
        }

        public void itemRemoved(CaloricItem caloricItem) {
        }

        public void itemChanged(CaloricItem caloricItem) {
        }
    }

    public static interface Listener {
        public void itemAdded(CaloricItem var1);

        public void itemRemoved(CaloricItem var1);

        public void itemChanged(CaloricItem var1);
    }
}

