/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.control.SummaryItemNode;
import edu.colorado.phet.eatingandexercise.model.CalorieSet;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;

public class PlateTopSummaryNode
extends PNode {
    private PNode layer = new PNode();
    private CalorieSet calorieSet;
    private PNode plate;
    private boolean showItems = false;

    public PlateTopSummaryNode(CalorieSet calorieSet, PNode pNode) {
        this.calorieSet = calorieSet;
        this.plate = pNode;
        this.addChild(this.layer);
        for (int i = 0; i < calorieSet.size(); ++i) {
            this.addItem(calorieSet.getItem(i));
        }
        calorieSet.addListener(new CalorieSet.Adapter(){

            public void itemAdded(CaloricItem caloricItem) {
                PlateTopSummaryNode.this.addItem(caloricItem);
            }

            public void itemRemoved(CaloricItem caloricItem) {
                for (int i = 0; i < PlateTopSummaryNode.this.layer.getChildrenCount(); ++i) {
                    SummaryItemNode summaryItemNode = (SummaryItemNode)PlateTopSummaryNode.this.layer.getChild(i);
                    if (summaryItemNode.getItem() != caloricItem) continue;
                    PlateTopSummaryNode.this.layer.removeChild(summaryItemNode);
                    break;
                }
                PlateTopSummaryNode.this.relayout();
            }
        });
        this.relayout();
    }

    public void addItem(final CaloricItem caloricItem) {
        if (this.showItems) {
            SummaryItemNode summaryItemNode = new SummaryItemNode(caloricItem, 1);
            summaryItemNode.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    PlateTopSummaryNode.this.calorieSet.removeItem(caloricItem);
                }
            });
            this.layer.addChild(summaryItemNode);
        }
        this.relayout();
    }

    public void relayout() {
        if (this.layer.getChildrenCount() > 0) {
            this.layer.getChild(0).setOffset(this.plate.getFullBounds().getX(), this.plate.getFullBounds().getY() - this.layer.getChild(0).getFullBounds().getHeight());
            for (int i = 1; i < this.layer.getChildrenCount(); ++i) {
                PNode pNode = this.layer.getChild(i - 1);
                this.layer.getChild(i).setOffset(pNode.getOffset().getX(), pNode.getFullBounds().getMinY() - this.layer.getChild(i).getFullBounds().getHeight());
            }
        }
    }
}

