/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.model.EatingAndExerciseUnits;
import edu.colorado.phet.eatingandexercise.model.Human;

public class ExerciseItem
extends CaloricItem {
    private double weightDependence;
    private double referenceWeightPounds;
    private double referenceCalories;
    private Human human;

    public ExerciseItem(String string, String string2, double d, double d2, double d3, Human human) {
        super(string, string2, d);
        this.weightDependence = d2;
        this.referenceCalories = d;
        this.referenceWeightPounds = d3;
        this.human = human;
        this.init();
    }

    private void init() {
        this.human.addListener(new Human.Adapter(){

            public void weightChanged() {
                ExerciseItem.this.updateCalories();
            }
        });
        this.updateCalories();
    }

    private void updateCalories() {
        double d = this.referenceCalories * (1.0 + this.weightDependence * (EatingAndExerciseUnits.kgToPounds(this.human.getMass()) - this.referenceWeightPounds) / this.referenceWeightPounds);
        this.setCalories(d);
    }

    public Object clone() {
        ExerciseItem exerciseItem = (ExerciseItem)super.clone();
        exerciseItem.weightDependence = this.weightDependence;
        exerciseItem.referenceCalories = this.referenceCalories;
        exerciseItem.referenceWeightPounds = this.referenceWeightPounds;
        exerciseItem.human = this.human;
        exerciseItem.init();
        return exerciseItem;
    }

    public String getLabelText() {
        String string = EatingAndExerciseResources.getString("one.hour");
        return "<html>" + string + " " + this.getName() + " " + "<br>(" + EatingAndExerciseStrings.KCAL_PER_DAY_FORMAT.format(this.getCalories()) + " " + EatingAndExerciseStrings.KCAL_PER_DAY + ")</html>";
    }
}

