/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.control.BarChartNodeAxisTitleLabelNode;
import edu.colorado.phet.eatingandexercise.control.CalorieNode;
import edu.colorado.phet.eatingandexercise.control.ChartNode;
import edu.colorado.phet.eatingandexercise.control.ExerciseSelectionPanel;
import edu.colorado.phet.eatingandexercise.control.FoodSelectionPanel;
import edu.colorado.phet.eatingandexercise.control.ICalorieSelectionPanel;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseCanvas;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseModel;
import edu.colorado.phet.eatingandexercise.view.BarChartElement;
import edu.colorado.phet.eatingandexercise.view.EatingAndExerciseColorScheme;
import edu.colorado.phet.eatingandexercise.view.StackedBarChartNode;
import edu.colorado.phet.eatingandexercise.view.StackedBarNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class CaloriePanel
extends PNode {
    private EatingAndExerciseCanvas phetPCanvas;
    private StackedBarChartNode stackedBarChart;
    private CalorieNode foodNode;
    private CalorieNode exerciseNode;
    private ChartNode chartNode;

    public CaloriePanel(final EatingAndExerciseModel eatingAndExerciseModel, EatingAndExerciseCanvas eatingAndExerciseCanvas, Frame frame) {
        this.phetPCanvas = eatingAndExerciseCanvas;
        this.chartNode = new ChartNode(eatingAndExerciseModel, eatingAndExerciseCanvas);
        this.addChild(this.chartNode);
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 3000.0, 0.0, 250.0);
        this.stackedBarChart = new StackedBarChartNode(linearFunction, EatingAndExerciseResources.getString("units.cal-per-day"), 10, 250.0, 1000.0, 8000.0);
        StackedBarNode stackedBarNode = new StackedBarNode(linearFunction, 100);
        Color color = Color.black;
        stackedBarNode.addElement(new BarChartElementAdapter(EatingAndExerciseStrings.FATS, (Paint)EatingAndExerciseColorScheme.FATS, eatingAndExerciseModel.getHuman().getLipids(), "stick_butter.png", color), StackedBarNode.NONE);
        stackedBarNode.addElement(new BarChartElementAdapter(EatingAndExerciseResources.getString("food.carbs"), (Paint)EatingAndExerciseColorScheme.CARBS, eatingAndExerciseModel.getHuman().getCarbs(), "carbs.png", color), StackedBarNode.NONE);
        stackedBarNode.addElement(new BarChartElementAdapter(EatingAndExerciseResources.getString("food.protien"), (Paint)EatingAndExerciseColorScheme.PROTEIN, eatingAndExerciseModel.getHuman().getProteins(), "j0413686.gif", color), StackedBarNode.NONE);
        StackedBarNode stackedBarNode2 = new StackedBarNode(linearFunction, 100);
        stackedBarNode2.addElement(new BarChartElementAdapter(EatingAndExerciseResources.getString("exercise.resting.bmr"), EatingAndExerciseColorScheme.BMR, eatingAndExerciseModel.getHuman().getBmr(), "heart2.png"), StackedBarNode.NONE);
        stackedBarNode2.addElement(new BarChartElementAdapter(EatingAndExerciseResources.getString("exercise.lifestyle"), EatingAndExerciseColorScheme.ACTIVITY, eatingAndExerciseModel.getHuman().getActivity(), "j0417518.png"), StackedBarNode.NONE);
        stackedBarNode2.addElement(new BarChartElementAdapter(EatingAndExerciseResources.getString("exercise"), EatingAndExerciseColorScheme.EXERCISE, eatingAndExerciseModel.getHuman().getExercise(), "road_biker.png"), StackedBarNode.NONE);
        this.stackedBarChart.addStackedBarNode(stackedBarNode);
        this.stackedBarChart.addStackedBarNode(stackedBarNode2);
        this.addChild(this.stackedBarChart);
        BarChartNodeAxisTitleLabelNode barChartNodeAxisTitleLabelNode = new BarChartNodeAxisTitleLabelNode(eatingAndExerciseCanvas, this.stackedBarChart, this);
        this.addChild(barChartNodeAxisTitleLabelNode);
        this.foodNode = new CalorieNode(frame, EatingAndExerciseResources.getString("edit.diet"), new Color(100, 100, 255), eatingAndExerciseModel.getAvailableFoods(), eatingAndExerciseModel.getHuman().getSelectedFoods(), EatingAndExerciseResources.getString("food.sources"), EatingAndExerciseResources.getString("diet"), "plate-2.png"){

            protected ICalorieSelectionPanel createCalorieSelectionPanel() {
                return new FoodSelectionPanel(eatingAndExerciseModel.getHuman(), this.getAvailable(), this.getCalorieSet(), this.getAvailableTitle(), this.getSelectedTitle());
            }
        };
        this.foodNode.addOverlapTarget(stackedBarNode);
        this.addChild(this.foodNode);
        this.exerciseNode = new CalorieNode(frame, EatingAndExerciseResources.getString("exercise.edit"), Color.red, eatingAndExerciseModel.getAvailableExercise(), eatingAndExerciseModel.getHuman().getSelectedExercise(), EatingAndExerciseResources.getString("menu.options"), EatingAndExerciseResources.getString("exercise.daily"), "planner.png"){

            protected ICalorieSelectionPanel createCalorieSelectionPanel() {
                return new ExerciseSelectionPanel(eatingAndExerciseModel.getHuman(), this.getAvailable(), this.getCalorieSet(), this.getAvailableTitle(), this.getSelectedTitle());
            }
        };
        this.exerciseNode.addOverlapTarget(stackedBarNode2);
        this.addChild(this.exerciseNode);
        this.addChild(this.foodNode.getTooltipLayer());
        this.addChild(this.exerciseNode.getTooltipLayer());
        this.relayout();
        eatingAndExerciseCanvas.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                CaloriePanel.this.relayout();
            }

            public void componentResized(ComponentEvent componentEvent) {
                CaloriePanel.this.relayout();
            }
        });
    }

    public void resetAll() {
        this.chartNode.resetAll();
        this.foodNode.resetAll();
        this.exerciseNode.resetAll();
        this.stackedBarChart.resetAll();
    }

    public ChartNode getChartNode() {
        return this.chartNode;
    }

    public void applicationStarted() {
    }

    public void addEditorClosedListener(ActionListener actionListener) {
        this.foodNode.addEditorClosedListener(actionListener);
        this.exerciseNode.addEditorClosedListener(actionListener);
    }

    public void clearAndResetDomains() {
        this.chartNode.clearAndResetDomains();
    }

    public void addFoodPressedListener(ActionListener actionListener) {
        this.foodNode.addItemPressedListener(actionListener);
    }

    public PNode getPlateNode() {
        return this.foodNode.getDropTarget();
    }

    public void addExerciseDraggedListener(ActionListener actionListener) {
        this.exerciseNode.addItemPressedListener(actionListener);
    }

    public PNode getDiaryNode() {
        return this.exerciseNode.getDropTarget();
    }

    private void relayout() {
        double d = (double)this.phetPCanvas.getWidth() - this.getOffset().getX();
        this.stackedBarChart.setOffset(d / 2.0 - this.stackedBarChart.getFullBounds().getWidth() / 2.0, this.foodNode.getPlateBottomY());
        this.foodNode.setOffset(this.stackedBarChart.getFullBounds().getX() - this.foodNode.getDropTarget().getWidth(), 0.0);
        this.exerciseNode.setOffset(this.stackedBarChart.getFullBounds().getMaxX() + 25.0, 0.0);
        double d2 = (double)this.phetPCanvas.getWidth() - this.phetPCanvas.getControlPanelWidth();
        this.chartNode.relayout(d2, (double)this.phetPCanvas.getHeight() - this.foodNode.getPlateBottomY());
        this.chartNode.setOffset(0.0, this.foodNode.getPlateBottomY());
    }

    public static class BarChartElementAdapter
    extends BarChartElement {
        public BarChartElementAdapter(String string, Paint paint, final DefaultTemporalVariable defaultTemporalVariable, String string2, Color color) {
            super(string, paint, defaultTemporalVariable.getValue(), EatingAndExerciseResources.getImage(string2), color);
            defaultTemporalVariable.addListener(new IVariable.Listener(){

                public void valueChanged() {
                    BarChartElementAdapter.this.setValue(defaultTemporalVariable.getValue());
                }
            });
            this.addListener(new BarChartElement.Listener(){

                public void valueChanged() {
                    defaultTemporalVariable.setValue(BarChartElementAdapter.this.getValue());
                }
            });
        }

        public BarChartElementAdapter(String string, Paint paint, DefaultTemporalVariable defaultTemporalVariable, String string2) {
            this(string, paint, defaultTemporalVariable, string2, Color.black);
        }
    }
}

