/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.control.PNodeComponent;
import edu.colorado.phet.eatingandexercise.control.valuenode.LinearValueControlNode;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.CaloricFoodItem;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class BalancedDietDialog
extends PaintImmediateDialog {
    public BalancedDietDialog(final CaloricFoodItem caloricFoodItem) {
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        JLabel jLabel = new JLabel(caloricFoodItem.getLabelText(), new ImageIcon(EatingAndExerciseResources.getImage(caloricFoodItem.getImage())), 0){

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(graphics);
            }
        };
        ((Container)verticalLayoutPanel).add(jLabel);
        LinearValueControlNode linearValueControlNode = new LinearValueControlNode(EatingAndExerciseResources.getString("units.calories"), EatingAndExerciseResources.getString("units.cal"), 5.0, 4000.0, caloricFoodItem.getCalories(), new DefaultDecimalFormat("0.0"));
        linearValueControlNode.setTextFieldColumns(6);
        linearValueControlNode.addListener(new LinearValueControlNode.Listener(){

            public void valueChanged(double d) {
                caloricFoodItem.setTotalCalories(d);
            }
        });
        ((Container)verticalLayoutPanel).add(new PNodeComponent(linearValueControlNode));
        verticalLayoutPanel.setOpaque(true);
        verticalLayoutPanel.setBackground(Color.white);
        SwingUtils.centerWindowOnScreen(this);
        this.setContentPane(verticalLayoutPanel);
        this.pack();
    }

    public void resetAll() {
        this.dispose();
    }
}

