/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.help;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.piccolophet.help.AbstractHelpItem;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class MotionHelpBalloon
extends HelpBalloon {
    private PCanvas canvas;
    private boolean started;

    public MotionHelpBalloon(PCanvas pCanvas, String string) {
        super(pCanvas, string, HelpBalloon.TOP_LEFT, 100.0, 0.0);
        this.setBalloonVisible(false);
        this.setArrowVisible(false);
        this.setEnabled(true);
        this.canvas = pCanvas;
        this.started = false;
    }

    public PActivity animateTo(final PNode pNode, long l) {
        if (!this.started) {
            if (this.getRoot() == null) {
                throw new IllegalStateException("node has no root");
            }
            Point2D point2D = this.mapLocation(pNode, this.canvas);
            final PTransformActivity pTransformActivity = this.animateToPositionScaleRotation(point2D.getX(), point2D.getY(), 1.0, 0.0, l);
            pNode.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PAffineTransform pAffineTransform = MotionHelpBalloon.this.getTransform();
                    Point2D point2D = MotionHelpBalloon.this.mapLocation(pNode, MotionHelpBalloon.this.canvas);
                    pAffineTransform.setOffset(point2D.getX(), point2D.getY());
                    pAffineTransform.setScale(1.0);
                    pAffineTransform.setRotation(0.0);
                    double[] dArray = new double[6];
                    pAffineTransform.getMatrix(dArray);
                    pTransformActivity.setDestinationTransform(dArray);
                }
            });
            return pTransformActivity;
        }
        return null;
    }

    public void animateTo(JComponent jComponent, final double d) {
        AbstractHelpItem.IFollower iFollower = this.getFollower();
        if (iFollower != null) {
            iFollower.setFollowEnabled(false);
        }
        iFollower = new AbstractHelpItem.JComponentFollower(this, jComponent){
            private Timer timer;

            public void setFollowEnabled(boolean bl) {
                super.setFollowEnabled(bl);
                if (bl) {
                    if (this.timer != null) {
                        this.timer.stop();
                    }
                    this.timer = new Timer(30, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.updatePosition();
                        }
                    });
                    this.timer.start();
                }
            }

            public void updatePosition() {
                AbstractHelpItem abstractHelpItem = super.getHelpItem();
                if (abstractHelpItem.getVisible()) {
                    Point2D point2D = abstractHelpItem.mapLocation(super.getComponent());
                    Point2D point2D2 = abstractHelpItem.getOffset();
                    MutableVector2D mutableVector2D = new MutableVector2D(point2D2, point2D);
                    if (point2D2.distance(point2D) > d) {
                        Point2D.Double double_ = mutableVector2D.getInstanceOfMagnitude(d).getDestination(point2D2);
                        abstractHelpItem.setOffset(double_);
                    } else if (this.timer != null) {
                        this.timer.stop();
                    }
                }
            }
        };
        iFollower.setFollowEnabled(this.isEnabled());
        super.setFollower(iFollower);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.setPickable(bl);
        this.setChildrenPickable(bl);
    }
}

