/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.TimeData;
import java.util.ArrayList;

public class DefaultTimeSeries {
    private ArrayList<TimeData> data = new ArrayList();
    private ArrayList<ITemporalVariable.Listener> listeners = new ArrayList();

    public String toString() {
        return this.data.toString();
    }

    public TimeData getData(int n) {
        return this.data.get(n);
    }

    public int getSampleCount() {
        return this.data.size();
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).dataCleared();
            }
        }
    }

    public void addValue(double d, double d2) {
        TimeData timeData = new TimeData(d, d2);
        this.data.add(timeData);
        this.notifyObservers(timeData);
    }

    private void notifyObservers(TimeData timeData) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).dataAdded(timeData);
        }
    }

    public void addListener(ITemporalVariable.Listener listener) {
        this.listeners.add(listener);
    }

    public TimeData[] getData(double d, double d2) {
        ArrayList<TimeData> arrayList = new ArrayList<TimeData>();
        for (int i = 0; i < this.data.size(); ++i) {
            TimeData timeData = this.data.get(i);
            if (!(timeData.getTime() >= d) || !(timeData.getTime() <= d2)) continue;
            arrayList.add(timeData);
        }
        return arrayList.toArray(new TimeData[arrayList.size()]);
    }
}

